#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(23121);
 script_version ("$Revision: 1.5 $");
 script_bugtraq_id(4088, 4932, 4933);
 name["english"] = "Solaris 2.6 (sparc) : 106787-19";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Sun Security Patch number 106787-19
(Solstice Enterprise Agent 1.0.3: SNMP.).

Date this patch was last updated by Sun : Thu Apr 10 13:18:56 MDT 2003

You should install this patch for your system to be up-to-date.

Solution : http://sunsolve.sun.com/search/document.do?assetkey=1-21-106787-19-1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for patch 106787-19"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Solaris Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Solaris/showrev");
 exit(0);
}



include("solaris.inc");

e +=  solaris_check_patch(release:"5.6", arch:"sparc", patch:"106787-19", obsoleted_by:"", package:"SUNWmibii", version:"1.3,REV=1998.09.08.15.08");
e +=  solaris_check_patch(release:"5.6", arch:"sparc", patch:"106787-19", obsoleted_by:"", package:"SUNWsacom", version:"1.3,REV=1998.09.08.15.08");
e +=  solaris_check_patch(release:"5.6", arch:"sparc", patch:"106787-19", obsoleted_by:"", package:"SUNWsadmi", version:"1.3,REV=1998.09.08.15.08");
e +=  solaris_check_patch(release:"5.6", arch:"sparc", patch:"106787-19", obsoleted_by:"", package:"SUNWsasnm", version:"1.3,REV=1998.09.08.15.08");
if ( e < 0 ) { 
	if ( NASL_LEVEL < 3000 ) 
	   security_hole(0);
	else  
	   security_hole(port:0, extra:solaris_get_report());
	exit(0); 
} 
else 
{
	set_kb_item(name:"BID-4088", value:TRUE);
	set_kb_item(name:"BID-4932", value:TRUE);
	set_kb_item(name:"BID-4933", value:TRUE);
}
