#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(23138);
 script_version ("$Revision: 1.5 $");
 script_bugtraq_id(4494, 7641);
 name["english"] = "Solaris 2.6 (sparc) : 109208-21";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Sun Security Patch number 109208-21
(Sun Cluster 2.2: Framework/Comm Patch).

Date this patch was last updated by Sun : Wed Jan 28 10:11:10 MST 2004

You should install this patch for your system to be up-to-date.

Solution : http://sunsolve.sun.com/search/document.do?assetkey=1-21-109208-21-1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for patch 109208-21"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Solaris Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Solaris/showrev");
 exit(0);
}



include("solaris.inc");

e +=  solaris_check_patch(release:"5.6", arch:"sparc", patch:"109208-21", obsoleted_by:"", package:"SUNWsci", version:"2.2,REV=1999.02.09.23.00");
e +=  solaris_check_patch(release:"5.6", arch:"sparc", patch:"109208-21", obsoleted_by:"", package:"SUNWscid", version:"2.2,REV=1999.02.09.23.00");
e +=  solaris_check_patch(release:"5.6", arch:"sparc", patch:"109208-21", obsoleted_by:"", package:"SUNWsma", version:"2.2,REV=1999.02.09.23.00");
if ( e < 0 ) { 
	if ( NASL_LEVEL < 3000 ) 
	   security_hole(0);
	else  
	   security_hole(port:0, extra:solaris_get_report());
	exit(0); 
} 
else 
{
	set_kb_item(name:"BID-4494", value:TRUE);
	set_kb_item(name:"BID-7641", value:TRUE);
}
