#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(23194);
 script_version ("$Revision: 1.5 $");
 name["english"] = "Solaris 2.6 (i386) : 109735-13";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Sun Security Patch number 109735-13
(SunScreen 3.1 (Intel) miscellaneous fixes Solaris_x86).

Date this patch was last updated by Sun : Thu Sep 02 10:23:07 MDT 2004

You should install this patch for your system to be up-to-date.

Solution : http://sunsolve.sun.com/search/document.do?assetkey=1-21-109735-13-1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for patch 109735-13"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Solaris Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Solaris/showrev");
 exit(0);
}



include("solaris.inc");

e +=  solaris_check_patch(release:"5.6_x86", arch:"i386", patch:"109735-13", obsoleted_by:"", package:"SUNWicgSA", version:"3.1,REV=20000427");
e +=  solaris_check_patch(release:"5.6_x86", arch:"i386", patch:"109735-13", obsoleted_by:"", package:"SUNWicgSS", version:"3.1,REV=20000427");
if ( e < 0 ) { 
	if ( NASL_LEVEL < 3000 ) 
	   security_hole(0);
	else  
	   security_hole(port:0, extra:solaris_get_report());
	exit(0); 
} 
