#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(13193);
 script_version ("$Revision: 1.20 $");
 script_bugtraq_id(10594, 5161, 5986, 6309, 7820, 8314, 8831, 8929, 9477, 9962);
 name["english"] = "Solaris 7 (i386) : 106542-43";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Sun Security Patch number 106542-43
(SunOS 5.7_x86: Kernel Update Patch).

Date this patch was last updated by Sun : Mon Nov 27 11:41:49 MST 2006

You should install this patch for your system to be up-to-date.

Solution : http://sunsolve.sun.com/search/document.do?assetkey=1-21-106542-43-1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for patch 106542-43"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Solaris Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Solaris/showrev");
 exit(0);
}



include("solaris.inc");

e +=  solaris_check_patch(release:"5.7_x86", arch:"i386", patch:"106542-43", obsoleted_by:"", package:"SUNWarc", version:"11.7.0,REV=1998.09.01.04.53");
e +=  solaris_check_patch(release:"5.7_x86", arch:"i386", patch:"106542-43", obsoleted_by:"", package:"SUNWatfsr", version:"11.7.0,REV=1998.09.01.04.53");
e +=  solaris_check_patch(release:"5.7_x86", arch:"i386", patch:"106542-43", obsoleted_by:"", package:"SUNWcsl", version:"11.7.0,REV=1998.09.01.04.53");
e +=  solaris_check_patch(release:"5.7_x86", arch:"i386", patch:"106542-43", obsoleted_by:"", package:"SUNWcsr", version:"11.7.0,REV=1998.09.01.04.53");
e +=  solaris_check_patch(release:"5.7_x86", arch:"i386", patch:"106542-43", obsoleted_by:"", package:"SUNWcsu", version:"11.7.0,REV=1998.10.06.01.22");
e +=  solaris_check_patch(release:"5.7_x86", arch:"i386", patch:"106542-43", obsoleted_by:"", package:"SUNWdpl", version:"11.7.0,REV=1998.09.01.04.53");
e +=  solaris_check_patch(release:"5.7_x86", arch:"i386", patch:"106542-43", obsoleted_by:"", package:"SUNWesu", version:"11.7.0,REV=1998.09.01.04.53");
e +=  solaris_check_patch(release:"5.7_x86", arch:"i386", patch:"106542-43", obsoleted_by:"", package:"SUNWhea", version:"11.7.0,REV=1998.09.01.04.53");
e +=  solaris_check_patch(release:"5.7_x86", arch:"i386", patch:"106542-43", obsoleted_by:"", package:"SUNWipc", version:"11.7.0,REV=1998.09.01.04.53");
e +=  solaris_check_patch(release:"5.7_x86", arch:"i386", patch:"106542-43", obsoleted_by:"", package:"SUNWnisu", version:"11.7.0,REV=1998.09.01.04.53");
e +=  solaris_check_patch(release:"5.7_x86", arch:"i386", patch:"106542-43", obsoleted_by:"", package:"SUNWpcmci", version:"11.7.0,REV=1998.09.01.04.53");
e +=  solaris_check_patch(release:"5.7_x86", arch:"i386", patch:"106542-43", obsoleted_by:"", package:"SUNWpcmcu", version:"11.7.0,REV=1998.09.01.04.53");
e +=  solaris_check_patch(release:"5.7_x86", arch:"i386", patch:"106542-43", obsoleted_by:"", package:"SUNWscpu", version:"11.7.0,REV=1998.09.01.04.53");
e +=  solaris_check_patch(release:"5.7_x86", arch:"i386", patch:"106542-43", obsoleted_by:"", package:"SUNWtnfc", version:"11.7.0,REV=1998.09.01.04.53");
e +=  solaris_check_patch(release:"5.7_x86", arch:"i386", patch:"106542-43", obsoleted_by:"", package:"SUNWtoo", version:"11.7.0,REV=1998.09.01.04.53");
e +=  solaris_check_patch(release:"5.7_x86", arch:"i386", patch:"106542-43", obsoleted_by:"", package:"SUNWvolr", version:"11.7.0,REV=1998.09.01.04.53");
e +=  solaris_check_patch(release:"5.7_x86", arch:"i386", patch:"106542-43", obsoleted_by:"", package:"SUNWvolu", version:"11.7.0,REV=1998.09.01.04.53");
e +=  solaris_check_patch(release:"5.7_x86", arch:"i386", patch:"106542-43", obsoleted_by:"", package:"SUNWypu", version:"11.7.0,REV=1998.09.01.04.53");
if ( e < 0 ) { 
	if ( NASL_LEVEL < 3000 ) 
	   security_hole(0);
	else  
	   security_hole(port:0, extra:solaris_get_report());
	exit(0); 
} 
else 
{
	set_kb_item(name:"BID-10594", value:TRUE);
	set_kb_item(name:"BID-5161", value:TRUE);
	set_kb_item(name:"BID-5986", value:TRUE);
	set_kb_item(name:"BID-6309", value:TRUE);
	set_kb_item(name:"BID-7820", value:TRUE);
	set_kb_item(name:"BID-8314", value:TRUE);
	set_kb_item(name:"BID-8831", value:TRUE);
	set_kb_item(name:"BID-8929", value:TRUE);
	set_kb_item(name:"BID-9477", value:TRUE);
	set_kb_item(name:"BID-9962", value:TRUE);
}
