#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(13232);
 script_version ("$Revision: 1.9 $");
 script_bugtraq_id(3382, 5444, 641);
 name["english"] = "Solaris 7 (i386) : 107894-20";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Sun Security Patch number 107894-20
(OpenWindows 3.6.1_x86: Tooltalk patch).

Date this patch was last updated by Sun : Wed Sep 24 11:03:01 MDT 2003

You should install this patch for your system to be up-to-date.

Solution : http://sunsolve.sun.com/search/document.do?assetkey=1-21-107894-20-1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for patch 107894-20"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Solaris Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Solaris/showrev");
 exit(0);
}



include("solaris.inc");

e +=  solaris_check_patch(release:"5.7_x86", arch:"i386", patch:"107894-20", obsoleted_by:"", package:"SUNWtltk", version:"3.7.0,REV=10.98.09.12");
e +=  solaris_check_patch(release:"5.7_x86", arch:"i386", patch:"107894-20", obsoleted_by:"", package:"SUNWtltkm", version:"3.7.0,REV=10.98.09.12");
if ( e < 0 ) { 
	if ( NASL_LEVEL < 3000 ) 
	   security_hole(0);
	else  
	   security_hole(port:0, extra:solaris_get_report());
	exit(0); 
} 
else 
{
	set_kb_item(name:"BID-3382", value:TRUE);
	set_kb_item(name:"BID-5444", value:TRUE);
	set_kb_item(name:"BID-641", value:TRUE);
}
