#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(23345);
 script_version ("$Revision: 1.5 $");
 script_bugtraq_id(5361, 5362, 5364);
 name["english"] = "Solaris 8 (sparc) : 112869-02";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Sun Security Patch number 112869-02
(Sun Crypto Accelerator 1000 Patch).

Date this patch was last updated by Sun : Wed Aug 14 13:32:59 MDT 2002

You should install this patch for your system to be up-to-date.

Solution : http://sunsolve.sun.com/search/document.do?assetkey=1-21-112869-02-1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for patch 112869-02"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Solaris Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Solaris/showrev");
 exit(0);
}



include("solaris.inc");

e +=  solaris_check_patch(release:"5.8", arch:"sparc", patch:"112869-02", obsoleted_by:"", package:"SUNWcrysl", version:"1.0.0,REV=2002.01.31.15.55");
e +=  solaris_check_patch(release:"5.8", arch:"sparc", patch:"112869-02", obsoleted_by:"", package:"SUNWcrysu", version:"1.0.0,REV=2002.01.23.15.22");
if ( e < 0 ) { 
	if ( NASL_LEVEL < 3000 ) 
	   security_hole(0);
	else  
	   security_hole(port:0, extra:solaris_get_report());
	exit(0); 
} 
else 
{
	set_kb_item(name:"BID-5361", value:TRUE);
	set_kb_item(name:"BID-5362", value:TRUE);
	set_kb_item(name:"BID-5364", value:TRUE);
}
