#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(29828);
 script_version ("$Revision: 1.3 $");
 name["english"] = "Solaris 8 (sparc) : 128624-04";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Sun Security Patch number 128624-04
(SunOS 5.8: LDAP2 client, libc, libthread and libnsl libraries patch).

Date this patch was last updated by Sun : Fri Feb 29 13:35:06 MST 2008

You should install this patch for your system to be up-to-date.

Solution : http://sunsolve.sun.com/search/document.do?assetkey=1-21-128624-04-1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for patch 128624-04"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Solaris Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Solaris/showrev");
 exit(0);
}



include("solaris.inc");

e +=  solaris_check_patch(release:"5.8", arch:"sparc", patch:"128624-04", obsoleted_by:"", package:"SUNWapppr", version:"11.8.0,REV=2000.01.08.18.12");
e +=  solaris_check_patch(release:"5.8", arch:"sparc", patch:"128624-04", obsoleted_by:"", package:"SUNWapppu", version:"11.8.0,REV=2000.01.08.18.12");
e +=  solaris_check_patch(release:"5.8", arch:"sparc", patch:"128624-04", obsoleted_by:"", package:"SUNWarc", version:"11.8.0,REV=2000.01.08.18.12");
e +=  solaris_check_patch(release:"5.8", arch:"sparc", patch:"128624-04", obsoleted_by:"", package:"SUNWarcx", version:"11.8.0,REV=2000.01.08.18.12");
e +=  solaris_check_patch(release:"5.8", arch:"sparc", patch:"128624-04", obsoleted_by:"", package:"SUNWatfsr", version:"11.8.0,REV=2000.01.08.18.12");
e +=  solaris_check_patch(release:"5.8", arch:"sparc", patch:"128624-04", obsoleted_by:"", package:"SUNWatfsu", version:"11.8.0,REV=2000.01.08.18.12");
e +=  solaris_check_patch(release:"5.8", arch:"sparc", patch:"128624-04", obsoleted_by:"", package:"SUNWcsl", version:"11.8.0,REV=2000.01.08.18.12");
e +=  solaris_check_patch(release:"5.8", arch:"sparc", patch:"128624-04", obsoleted_by:"", package:"SUNWcslx", version:"11.8.0,REV=2000.01.08.18.12");
e +=  solaris_check_patch(release:"5.8", arch:"sparc", patch:"128624-04", obsoleted_by:"", package:"SUNWcsr", version:"11.8.0,REV=2000.01.08.18.12");
e +=  solaris_check_patch(release:"5.8", arch:"sparc", patch:"128624-04", obsoleted_by:"", package:"SUNWcstl", version:"11.8.0,REV=2000.01.08.18.12");
e +=  solaris_check_patch(release:"5.8", arch:"sparc", patch:"128624-04", obsoleted_by:"", package:"SUNWcstlx", version:"11.8.0,REV=2000.01.08.18.12");
e +=  solaris_check_patch(release:"5.8", arch:"sparc", patch:"128624-04", obsoleted_by:"", package:"SUNWcsu", version:"11.8.0,REV=2000.01.08.18.12");
e +=  solaris_check_patch(release:"5.8", arch:"sparc", patch:"128624-04", obsoleted_by:"", package:"SUNWcsxu", version:"11.8.0,REV=2000.01.08.18.12");
e +=  solaris_check_patch(release:"5.8", arch:"sparc", patch:"128624-04", obsoleted_by:"", package:"SUNWdpl", version:"11.8.0,REV=2000.01.08.18.12");
e +=  solaris_check_patch(release:"5.8", arch:"sparc", patch:"128624-04", obsoleted_by:"", package:"SUNWdplx", version:"11.8.0,REV=2000.01.08.18.12");
e +=  solaris_check_patch(release:"5.8", arch:"sparc", patch:"128624-04", obsoleted_by:"", package:"SUNWhea", version:"11.8.0,REV=2000.01.08.18.12");
e +=  solaris_check_patch(release:"5.8", arch:"sparc", patch:"128624-04", obsoleted_by:"", package:"SUNWlldap", version:"11.8.0,REV=2000.01.08.18.12");
e +=  solaris_check_patch(release:"5.8", arch:"sparc", patch:"128624-04", obsoleted_by:"", package:"SUNWmdb", version:"11.8.0,REV=2000.01.08.18.12");
e +=  solaris_check_patch(release:"5.8", arch:"sparc", patch:"128624-04", obsoleted_by:"", package:"SUNWmdbx", version:"11.8.0,REV=2000.01.08.18.12");
e +=  solaris_check_patch(release:"5.8", arch:"sparc", patch:"128624-04", obsoleted_by:"", package:"SUNWnisr", version:"11.8.0,REV=2000.01.08.18.12");
e +=  solaris_check_patch(release:"5.8", arch:"sparc", patch:"128624-04", obsoleted_by:"", package:"SUNWnisu", version:"11.8.0,REV=2000.01.08.18.12");
e +=  solaris_check_patch(release:"5.8", arch:"sparc", patch:"128624-04", obsoleted_by:"", package:"SUNWpppd", version:"11.8.0,REV=2001.02.21.14.02");
e +=  solaris_check_patch(release:"5.8", arch:"sparc", patch:"128624-04", obsoleted_by:"", package:"SUNWpppdr", version:"11.8.0,REV=2001.02.21.14.02");
e +=  solaris_check_patch(release:"5.8", arch:"sparc", patch:"128624-04", obsoleted_by:"", package:"SUNWpppdu", version:"11.8.0,REV=2001.02.21.14.02");
e +=  solaris_check_patch(release:"5.8", arch:"sparc", patch:"128624-04", obsoleted_by:"", package:"SUNWpppdx", version:"11.8.0,REV=2001.02.21.14.02");
e +=  solaris_check_patch(release:"5.8", arch:"sparc", patch:"128624-04", obsoleted_by:"", package:"SUNWpppgS", version:"11.8.0,REV=2001.02.21.14.02");
if ( e < 0 ) { 
	if ( NASL_LEVEL < 3000 ) 
	   security_hole(0);
	else  
	   security_hole(port:0, extra:solaris_get_report());
	exit(0); 
} 
