#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(13431);
 script_version ("$Revision: 1.13 $");
 script_bugtraq_id(7240);
 script_cve_id("CVE-2003-0092");
 name["english"] = "Solaris 8 (i386) : 109355-25";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Sun Security Patch number 109355-25
(CDE 1.4_x86: dtsession patch).

Date this patch was last updated by Sun : Mon Jun 25 11:17:04 MDT 2007

You should install this patch for your system to be up-to-date.

Solution : http://sunsolve.sun.com/search/document.do?assetkey=1-21-109355-25-1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for patch 109355-25"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Solaris Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Solaris/showrev");
 exit(0);
}



include("solaris.inc");

e +=  solaris_check_patch(release:"5.8_x86", arch:"i386", patch:"109355-25", obsoleted_by:"", package:"SUNWdtdte", version:"1.4,REV=10.1999.12.07");
e +=  solaris_check_patch(release:"5.8_x86", arch:"i386", patch:"109355-25", obsoleted_by:"", package:"SUNWdtma", version:"1.4,REV=10.1999.12.02");
e +=  solaris_check_patch(release:"5.8_x86", arch:"i386", patch:"109355-25", obsoleted_by:"", package:"SUNWdtwm", version:"1.4,REV=10.1999.12.02");
if ( e < 0 ) { 
	if ( NASL_LEVEL < 3000 ) 
	   security_hole(0);
	else  
	   security_hole(port:0, extra:solaris_get_report());
	exit(0); 
} 
else 
{
	set_kb_item(name:"CVE-2003-0092", value:TRUE);
	set_kb_item(name:"BID-7240", value:TRUE);
}
