#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(23448);
 script_version ("$Revision: 1.15 $");
 name["english"] = "Solaris 8 (i386) : 112606-04";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Sun Security Patch number 112606-04
(/kernel/fs/autofs and /usr/lib/autofs/automountd patch).

Date this patch was last updated by Sun : Fri Apr 04 13:05:56 MST 2003

You should install this patch for your system to be up-to-date.

Solution : http://sunsolve.sun.com/search/document.do?assetkey=1-21-112606-04-1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for patch 112606-04"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Solaris Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Solaris/showrev");
 exit(0);
}



include("solaris.inc");

e +=  solaris_check_patch(release:"5.8_x86", arch:"i386", patch:"112606-04", obsoleted_by:"108994-05 108994-07 108994-18 108994-31 108994-45 108994-65 108994-66 108994-67 128625-01 128625-04", package:"SUNWatfsr", version:"11.8.0,REV=2000.01.08.18.17");
e +=  solaris_check_patch(release:"5.8_x86", arch:"i386", patch:"112606-04", obsoleted_by:"108994-05 108994-07 108994-18 108994-31 108994-45 108994-65 108994-66 108994-67 128625-01 128625-04", package:"SUNWatfsu", version:"11.8.0,REV=2000.01.08.18.17");
e +=  solaris_check_patch(release:"5.8_x86", arch:"i386", patch:"112606-04", obsoleted_by:"108994-05 108994-07 108994-18 108994-31 108994-45 108994-65 108994-66 108994-67 128625-01 128625-04", package:"SUNWhea", version:"11.8.0,REV=2000.01.08.18.17");
if ( e < 0 ) { 
	if ( NASL_LEVEL < 3000 ) 
	   security_hole(0);
	else  
	   security_hole(port:0, extra:solaris_get_report());
	exit(0); 
} 
