#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(19842);
 script_version ("$Revision: 1.12 $");
 name["english"] = "Solaris 9 (sparc) : 119211-16";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Sun Security Patch number 119211-16
(NSS_NSPR_JSS 3.11.8: NSPR 4.6.8 / NSS 3.11.8 / JSS 4.2.5).

Date this patch was last updated by Sun : Fri Feb 15 09:56:34 MST 2008

You should install this patch for your system to be up-to-date.

Solution : http://sunsolve.sun.com/search/document.do?assetkey=1-21-119211-16-1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for patch 119211-16"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Solaris Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Solaris/showrev");
 exit(0);
}



include("solaris.inc");

e +=  solaris_check_patch(release:"5.9", arch:"sparc", patch:"119211-16", obsoleted_by:"", package:"SUNWjss", version:"3.1.2.3,REV=2003.03.08.12.17");
e +=  solaris_check_patch(release:"5.9", arch:"sparc", patch:"119211-16", obsoleted_by:"", package:"SUNWjssx", version:"3.1.2.3,REV=2003.03.08.12.22");
e +=  solaris_check_patch(release:"5.9", arch:"sparc", patch:"119211-16", obsoleted_by:"", package:"SUNWpr", version:"4.1.2,REV=2002.09.03.00.17");
e +=  solaris_check_patch(release:"5.9", arch:"sparc", patch:"119211-16", obsoleted_by:"", package:"SUNWprd", version:"4.1.6,REV=2003.09.08.10.19");
e +=  solaris_check_patch(release:"5.9", arch:"sparc", patch:"119211-16", obsoleted_by:"", package:"SUNWprx", version:"4.1.2,REV=2002.09.03.00.17");
e +=  solaris_check_patch(release:"5.9", arch:"sparc", patch:"119211-16", obsoleted_by:"", package:"SUNWtls", version:"3.3.2,REV=2002.09.18.12.49");
e +=  solaris_check_patch(release:"5.9", arch:"sparc", patch:"119211-16", obsoleted_by:"", package:"SUNWtlsd", version:"3.3.6,REV=2003.09.08.10.30");
e +=  solaris_check_patch(release:"5.9", arch:"sparc", patch:"119211-16", obsoleted_by:"", package:"SUNWtlsu", version:"3.3.7,REV=2003.12.01.12.23");
e +=  solaris_check_patch(release:"5.9", arch:"sparc", patch:"119211-16", obsoleted_by:"", package:"SUNWtlsux", version:"3.3.10,REV=2004.03.25.01.10");
e +=  solaris_check_patch(release:"5.9", arch:"sparc", patch:"119211-16", obsoleted_by:"", package:"SUNWtlsx", version:"3.3.2,REV=2002.09.18.12.49");
if ( e < 0 ) { 
	if ( NASL_LEVEL < 3000 ) 
	   security_hole(0);
	else  
	   security_hole(port:0, extra:solaris_get_report());
	exit(0); 
} 
