#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(23555);
 script_version ("$Revision: 1.11 $");
 name["english"] = "Solaris 9 (sparc) : 119670-01";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Sun Security Patch number 119670-01
(Product Patch).

Date this patch was last updated by Sun : Wed Jan 18 11:38:57 MST 2006

You should install this patch for your system to be up-to-date.

Solution : http://sunsolve.sun.com/search/document.do?assetkey=1-21-119670-01-1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for patch 119670-01"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Solaris Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Solaris/showrev");
 exit(0);
}



include("solaris.inc");

e +=  solaris_check_patch(release:"5.9", arch:"sparc", patch:"119670-01", obsoleted_by:"116826-06", package:"SUNWebsc", version:"7.1,REV=230");
e +=  solaris_check_patch(release:"5.9", arch:"sparc", patch:"119670-01", obsoleted_by:"116826-06", package:"SUNWebsd", version:"7.1,REV=230");
e +=  solaris_check_patch(release:"5.9", arch:"sparc", patch:"119670-01", obsoleted_by:"116826-06", package:"SUNWebsm", version:"7.1,REV=230");
e +=  solaris_check_patch(release:"5.9", arch:"sparc", patch:"119670-01", obsoleted_by:"116826-06", package:"SUNWebsn", version:"7.1,REV=230");
e +=  solaris_check_patch(release:"5.9", arch:"sparc", patch:"119670-01", obsoleted_by:"116826-06", package:"SUNWebss", version:"7.1,REV=230");
if ( e < 0 ) { 
	if ( NASL_LEVEL < 3000 ) 
	   security_hole(0);
	else  
	   security_hole(port:0, extra:solaris_get_report());
	exit(0); 
} 
