#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(23569);
 script_version ("$Revision: 1.5 $");
 name["english"] = "Solaris 9 (i386) : 108670-18";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Sun Security Patch number 108670-18
(Solstice X.25 9.2 patch_x86).

Date this patch was last updated by Sun : Fri Mar 10 13:15:26 MST 2006

You should install this patch for your system to be up-to-date.

Solution : http://sunsolve.sun.com/search/document.do?assetkey=1-21-108670-18-1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for patch 108670-18"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Solaris Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Solaris/showrev");
 exit(0);
}



include("solaris.inc");

e +=  solaris_check_patch(release:"5.9_x86", arch:"i386", patch:"108670-18", obsoleted_by:"", package:"SUNWexpx", version:"1.1");
e +=  solaris_check_patch(release:"5.9_x86", arch:"i386", patch:"108670-18", obsoleted_by:"", package:"SUNWx25a", version:"9.2");
e +=  solaris_check_patch(release:"5.9_x86", arch:"i386", patch:"108670-18", obsoleted_by:"", package:"SUNWx25b", version:"9.2");
if ( e < 0 ) { 
	if ( NASL_LEVEL < 3000 ) 
	   security_hole(0);
	else  
	   security_hole(port:0, extra:solaris_get_report());
	exit(0); 
} 
