#
#  (C) Tenable Network Security
#


if (description)
{
  script_id(23931);
  script_version("$Revision: 1.4 $");

  script_cve_id("CVE-2006-6731", "CVE-2006-6736", "CVE-2006-6737", "CVE-2006-6745");
  script_bugtraq_id(21673, 21674, 21675);

  script_name(english:"Sun Java Runtime Environment Multiple Vulnerabilities (102729 and 102732)");
  script_summary(english:"Checks version of Sun JRE"); 
 
 desc = "
Synopsis :

The remote Windows host has a version of Sun's Java Runtime
Environment that is affected by several vulnerabilities. 

Description :

According to its version number, the Sun JRE installed on the remote
host has two buffer overflow issues that may allow an untrusted applet
to elevate its privileges to, for example, read or write local files
or to execute local applications subject to the privileges of the user
running the applet. 

In addition, another set of vulnerabilities may allow an untrusted
applet to access data in other applets. 

See also :

http://scary.beasts.org/security/CESA-2005-008.txt
http://sunsolve.sun.com/search/document.do?assetkey=1-26-102729-1
http://sunsolve.sun.com/search/document.do?assetkey=1-26-102732-1

Solution :

Update to Sun Java 2 JDK and JRE 5.0 Update 8 / SDK and JRE 1.4.2_13 /
SDK and JRE 1.3.1_19 or later and remove if necessary any affected
versions. 

Risk factor : 

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2006-2007 Tenable Network Security");

  script_dependencies("java_jre_version_invocation.nasl");
  script_require_keys("SMB/Java/JRE/Version");

  exit(0);
}


ver = get_kb_item("SMB/Java/JRE/Version");
if (!ver) exit(0);

if (
  egrep(pattern:"^1\.5\.0_0[0-7][^0-9]?", string:ver) ||
  egrep(pattern:"^1\.4\.([01]_|2_(0[0-9]|1[0-2][^0-9]?))", string:ver) ||
  egrep(pattern:"^1\.3\.(0_|1_(0[0-9]|1[0-8][^0-9]?))", string:ver)
) security_hole(get_kb_item("SMB/transport"));
