#
#  (C) Tenable Network Security
#


if (description)
{
  script_id(24022);
  script_version("$Revision: 1.3 $");

  script_cve_id("CVE-2007-0243");
  script_bugtraq_id(22085);

  script_name(english:"Sun Java Runtime Environment GIF Image Buffer Overflow Vulnerability (102760)");
  script_summary(english:"Checks version of Sun JRE"); 
 
 desc = "
Synopsis :

The remote Windows host has a version of Sun's Java Runtime
Environment that is affected by a buffer overflow vulnerability. 

Description :

According to its version number, the Sun JRE installed on the remote
host has a buffer overflow issue that can be triggered when parsing a
GIF image with the image width in an image block set to 0.  If an
attacker can trick a user on the affected system into processing a
specially-crafted image file, say by visiting a malicious web site, he
may be able to leverage this flaw to execute arbitrary code on the
affected system subject to the user's privileges. 

See also :

http://www.zerodayinitiative.com/advisories/ZDI-07-005.html
http://archives.neohapsis.com/archives/fulldisclosure/2007-01/0329.html
http://sunsolve.sun.com/search/document.do?assetkey=1-26-102760-1

Solution :

Update to Sun Java 2 JDK and JRE 5.0 Update 10 / SDK and JRE 1.4.2_13
/ SDK and JRE 1.3.1_19 or later and remove if necessary any affected
versions. 

Risk factor : 

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");

  script_dependencies("java_jre_version_invocation.nasl");
  script_require_keys("SMB/Java/JRE/Version");

  exit(0);
}


ver = get_kb_item("SMB/Java/JRE/Version");
if (!ver) exit(0);

if (
  egrep(pattern:"^1\.5\.0_0[0-9][^0-9]?", string:ver) ||
  egrep(pattern:"^1\.4\.([01]_|2_(0[0-9]|1[0-2][^0-9]?))", string:ver) ||
  egrep(pattern:"^1\.3\.(0_|1_(0[0-9]|1[0-8][^0-9]?))", string:ver)
) security_hole(get_kb_item("SMB/transport"));
