#
#  (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(25124);
  script_version("$Revision: 1.3 $");

  script_cve_id("CVE-2007-2435");
  script_bugtraq_id(23728);

  script_name(english:"Sun Java Web Start Unauthorized Access Vulnerability (102881)");
  script_summary(english:"Checks version of Sun JRE"); 
 
 desc = "
Synopsis :

The remote Windows host has an application that is affected by a
privilege escalation vulnerability. 

Description :

According to its version number, the Sun Java Runtime Environment
(JRE) installed on the remote host reportedly may allow an untrusted
application to elevate its privileges. 

See also :

http://sunsolve.sun.com/search/document.do?assetkey=1-26-102881-1

Solution :

Update to Sun Java 2 JDK and JRE 5.0 Update 11 / SDK and JRE 1.4.2_14
/ SDK or later and remove if necessary any affected versions. 

Risk factor : 

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("java_jre_version_invocation.nasl");
  script_require_keys("SMB/Java/JRE/Version");

  exit(0);
}


ver = get_kb_item("SMB/Java/JRE/Version");
if (!ver) exit(0);

if (
  egrep(pattern:"^1\.5\.0_(0[0-9]|10)[^0-9]?", string:ver) ||
  egrep(pattern:"^1\.4\.([01]_|2_(0[0-9]|1[0-3][^0-9]?))", string:ver)
) security_hole(get_kb_item("SMB/transport"));
