#
#  (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(25370);
  script_version("$Revision: 1.5 $");

  script_cve_id("CVE-2007-2788", "CVE-2007-2789");
  script_bugtraq_id(24004);

  script_name(english:"Sun Java Runtime Environment Image Parsing Vulnerabilities (102934)");
  script_summary(english:"Checks version of Sun JRE"); 
 
 desc = "
Synopsis :

The remote Windows host has an application that is affected by several
vulnerabilities. 

Description :

According to its version number, the Sun Java Runtime Environment
(JRE) installed on the remote host reportedly is affected by a buffer
overflow in its image processing code as well as another issue that
may cause the Java Virtual Machine to hang. 

See also :

http://sunsolve.sun.com/search/document.do?assetkey=1-26-102934-1

Solution :

Update to Sun Java JDK and JRE 6 Update 1 / JDK and JRE 5.0 Update 11
/ SDK and JRE 1.3.1_20 or later and remove if necessary any affected
versions. 

Risk factor : 

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("java_jre_version_invocation.nasl");
  script_require_keys("SMB/Java/JRE/Version");

  exit(0);
}


ver = get_kb_item("SMB/Java/JRE/Version");
if (!ver) exit(0);

if (
  egrep(pattern:"^1\.6\.0_00", string:ver) ||
  egrep(pattern:"^1\.5\.0_(0[0-9]|10)[^0-9]?", string:ver) ||
  egrep(pattern:"^1\.4\.([01]_|2_(0[0-9]|1[0-4][^0-9]?))", string:ver) ||
  egrep(pattern:"^1\.3\.(0_|1_[01][0-9])", string:ver)
) security_hole(get_kb_item("SMB/transport"));
