#
#  (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(26923);
  script_version("$Revision: 1.5 $");

  script_cve_id(
    "CVE-2007-5232",
    "CVE-2007-5236",
    "CVE-2007-5237",
    "CVE-2007-5238",
    "CVE-2007-5240",
    "CVE-2007-5273",
    "CVE-2007-5274",
    "CVE-2007-5689"
  );
  script_bugtraq_id(25918, 25920, 26185);

  script_name(english:"Sun Java Runtime Environment and Web Start Multiple Vulnerabilities (103072, 103073, 103078, 103079, 103112)");
  script_summary(english:"Checks version of Sun JRE"); 
 
 desc = "
Synopsis :

The remote Windows host has an application that is affected by
multiple vulnerabilities. 

Description :

According to its version number, the Sun Java Runtime Environment
(JRE) and/or Web Start installed on the remote host reportedly is
affected by several issues that could be abused to move / copy local
files, read or write local files, circumvent network access
restrictions, or elevate privileges. 

See also :

http://conference.hitb.org/hitbsecconf2007kl/?page_id=148
http://sunsolve.sun.com/search/document.do?assetkey=1-26-103072-1
http://sunsolve.sun.com/search/document.do?assetkey=1-26-103073-1
http://sunsolve.sun.com/search/document.do?assetkey=1-26-103078-1
http://sunsolve.sun.com/search/document.do?assetkey=1-26-103079-1
http://sunsolve.sun.com/search/document.do?assetkey=1-26-103112-1 

Solution :

Update to Sun JDK and JRE 6 Update 3 / JDK and JRE 5.0 Update 13 / SDK
and JRE 1.4.2_16 / SDK and JRE 1.3.1_21 or later and remove if
necessary any other affected versions. 

Risk factor : 

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("java_jre_version_invocation.nasl");
  script_require_keys("SMB/Java/JRE/Version");

  exit(0);
}


ver = get_kb_item("SMB/Java/JRE/Version");
if (!ver) exit(0);

if (
  egrep(pattern:"^1\.6\.0_0[0-2][^0-9]?", string:ver) ||
  egrep(pattern:"^1\.5\.0_(0[0-9]|1[0-2])[^0-9]?", string:ver) ||
  egrep(pattern:"^1\.4\.([01]_|2_(0[0-9]|1[0-5][^0-9]?))", string:ver) ||
  egrep(pattern:"^1\.3\.(0_|1_([01][0-9]|20[^0-9]?))", string:ver)
) security_hole(get_kb_item("SMB/transport"));
