#
#  (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(30149);
  script_version("$Revision: 1.3 $");

  script_bugtraq_id(27553);

  script_name(english:"Sun Java Runtime Environment External XML Entities Vulnerability (231246)");
  script_summary(english:"Checks version of Sun JRE"); 
 
 desc = "
Synopsis :

The remote Windows host has an application that is affected by a
security bypass vulnerability. 

Description :

According to its version number, the Sun Java Runtime Environment
(JRE) installed on the remote host reportedly allows processing of
external entity references even when the 'external general entities'
property is set to 'FALSE'.  This could allow an application to access
certain URL resources, such as files or web pages, or to launch a
denial of service attack against the system. 

Note that successful exploitation requires that specially-crafted XML
data be processed by a trusted application rather than by an untrusted
applet or Java Web Start application. 

See also :

http://archives.neohapsis.com/archives/bugtraq/2008-02/0007.html
http://sunsolve.sun.com/search/document.do?assetkey=1-66-231246-1

Solution :

Upgrade to Sun JDK and JRE 6 Update 4 or later.

Risk factor : 

Medium / CVSS Base Score : 4.0
(CVSS2#AV:N/AC:H/Au:N/C:P/I:N/A:P)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc.");

  script_dependencies("java_jre_version_invocation.nasl");
  script_require_keys("SMB/Java/JRE/Version");

  exit(0);
}


include("global_settings.inc");


# Check each installed JRE.
vers = get_kb_item("SMB/Java/JRE/Version");
if (isnull(vers)) exit(0);

info = "";
foreach ver (split(vers, sep:'\n', keep:FALSE))
{
  if (ver =~ "^1\.6\.0_0[0-3][^0-9]?")
    info += '  - ' + ver + '\n';
}


# Report if any were found to be vulnerable.
if (info)
{
  if (report_verbosity)
  {
    report = string(
      "The following vulnerable instance(s) of Sun's JRE are installed on the\n",
      "remote host :\n",
      "\n",
      info
    );
    security_warning(port:get_kb_item("SMB/transport"), extra:report);
  }
  else security_warning(get_kb_item("SMB/transport"));
}
