#
# (C) Tenable Network Security
#


  desc["english"] = "
Synopsis :

The remote web server is prone to a format string attack. 

Description :

The remote host is running SUN Java Web Console. 

The remote version of this service does not properly sanitize calls
to the syslog function. By sending a specially crafted request
it is possible to exploit this format string error.
An attacker can exploit it to execute code with the privileges of
the web server.

Solution : 

http://sunsolve.sun.com/search/document.do?assetkey=1-26-102854-1

Risk factor : 

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";


if (description) 
{
  script_id(25082);
  script_version("$Revision: 1.2 $");

  script_cve_id("CVE-2007-1681");
  script_bugtraq_id(23539);

  name["english"] = "Sun Java Web Console LibWebconsole_Services.SO Format String Vulnerability";
  script_name(english:name["english"]);
 
  script_description(english:desc["english"]);
 
  summary["english"] = "Checks Sun Java Web Console Version";
  script_summary(english:summary["english"]);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Gain root remotely");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");

  script_dependencie("http_version.nasl", "ssh_detect.nasl");
  script_require_ports("Services/www", 6789);

  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");
include("global_settings.inc");


function https_send_recv (port, data)
{
 local_var soc, buf;

 soc = open_sock_tcp(port, transport:ENCAPS_SSLv23);
 if (!soc)
   exit (0);

 send(socket:soc, data:data);
 buf = http_recv_body(socket:soc, length:0);
 if (!buf)
   exit (0);

 return buf;
}


ssh_port = get_kb_item("Services/ssh");
if (!ssh_port)
  exit(0);

banner = get_kb_item(string("SSH/banner/", ssh_port));
if ("Sun_SSH" >!< banner)
  exit(0); 

port = 6789;
if (!get_port_state(port))
  exit(0);


req = http_get(item:"/console/html/en/console_version.shtml", port:port);
res = https_send_recv(port:port, data:req);
if (res == NULL)
  exit(0);

if ("<title>Sun Java(TM) Web Console: Version</title>" >!< res)
  exit (0);

req = http_get(item:"/console/html/en/version.txt", port:port);
res = https_send_recv(port:port, data:req);
if (res == NULL)
  exit(0);

if (!egrep(pattern:"^[0-9]+\.[0-9]+\.[0-9]+$", string:res))
  exit (0);

vers = ereg_replace(pattern:"^([0-9]+\.[0-9]+\.[0-9]+)$", string:res, replace:"\1");
vers = split(vers, sep:".", keep:FALSE);

if ( (int(vers[0]) < 2) ||
     ((int(vers[0]) == 2) && (int(vers[1]) < 2)) ||
     ((int(vers[0]) == 2) && (int(vers[1]) == 2) && (int(vers[2]) < 6)) )
{
 # patched in 2.2.6 except for solaris 10 ( patched in 2.2.4 )
 req = http_get(item:"/console/html/en/versionDate.txt", port:port);
 res = https_send_recv(port:port, data:req);
 if (res == NULL)
   exit(0);

 if (!egrep(pattern:"^[0-9]+/[0-9]+/[0-9]+$", string:res))
   exit (0);
 
 date = ereg_replace(pattern:"$([0-9]+/[0-9]+/[0-9]+)$", string:res, replace:"\1");
 date = split(vers, sep:"/", keep:FALSE);

 if ( int(date[0]) < 2007 ||
      (int(date[0]) == 2007 && int(date[1]) < 3) )
   security_hole(port);
}
