#
#  (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(25693);
  script_version("$Revision: 1.5 $");

  script_cve_id("CVE-2007-3655");
  script_bugtraq_id(24832);

  script_name(english:"Sun Java Web Start JNLP Overflow Vulnerability (102996)");
  script_summary(english:"Checks version of Sun JRE"); 
 
 desc = "
Synopsis :

The remote Windows host has an application that may be prone to a
buffer overflow attack. 

Description :

There is reportedly a buffer overflow in the Java Web Start utility
distributed with the version of Sun Java Runtime Environment (JRE)
installed on the remote host.  If an attacker can convince a user on
the affected host to open a specially-crafted JNLP file, he may be
able to execute arbitrary code subject to the user's privileges. 

See also :

http://research.eeye.com/html/advisories/published/AD20070705.html
http://www.securityfocus.com/archive/1/473224/30/0/threaded
http://www.securityfocus.com/archive/1/473356/30/0/threaded
http://sunsolve.sun.com/search/document.do?assetkey=1-26-102996-1

Solution :

Upgrade to Sun Java JDK and JRE 6 Update 2 / JDK and JRE 5.0 Update 12
or later and remove if necessary any affected versions. 

Risk factor : 

Medium / CVSS Base Score : 6.8
(CVSS2#AV:N/AC:M/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("java_jre_version_invocation.nasl");
  script_require_keys("SMB/Java/JRE/Version");

  exit(0);
}


ver = get_kb_item("SMB/Java/JRE/Version");
if (!ver) exit(0);

if (
  egrep(pattern:"^1\.6\.0_0[01][^0-9]?", string:ver) ||
  egrep(pattern:"^1\.5\.0_(0[0-9]|1[01])[^0-9]?", string:ver)
) security_warning(get_kb_item("SMB/transport"));
