# -*- Fundamental -*-
#
# 
# (C) 2007 Tenable Network Security
#
# This script is released under one of the Tenable Script Licenses and may not
# be used from within scripts released under another license without the
# authorization from Tenable Network Security Inc.
#
# See the following licenses for details :
#  http://www.nessus.org/plugins/RegisteredFeed.pdf
#  http://www.nessus.org/plugins/TenableCommercial.pdf
#  http://www.nessus.org/plugins/DirectFeed.pdf
#  http://www.nessus.org/plugins/DirectFeedCommercial.pdf
#
#
# @NOGPL@
#
# sunrpc_func.inc 
# $Revision: 1.3 $
#


include ("byte_func.inc");

global_var __rpc_stream, __rpc_stream_length, __rpc_stream_pos, __rpc_stream_error;

function rpc_packet (prog, vers, proc, data, udp)
{
 local_var xid, pack;

 xid = rand ();

 if (isnull(udp) || udp == FALSE)
   pack = 
	mkbyte (0x80) + # Last fragment
	mkbyte (0) + mkword (strlen(data) + 0x28) ; # fragment length
 else
   pack = NULL;

 pack += 
	mkdword (xid) + # XID
	mkdword (0)   + # Call
	mkdword (2)   + # RPC version = 2
	mkdword (prog) + # program
	mkdword (vers) + # program version
	mkdword (proc) + # Procedure
	mkdword (0) + mkdword (0) + # Null credential
	mkdword (0) + mkdword (0) + # Null verifier
	data;

 return pack;
}


function rpc_sendrecv (socket, packet, udp)
{
 local_var len, data, acc;

 send (socket:socket, data:packet);

 if (isnull(udp) || udp == FALSE)
 {
  data = recv (socket:socket, length:4, min:4);

  # does not care about multiple fragment/big packets
  len = getword (blob:data, pos:2);
  data = recv (socket:socket, min:len, length:len);

  if (strlen(data) != len)
    return NULL;
 }
 else
  data = recv (socket:socket, min:len, length:4096);

 if (strlen(data) < 24)
   return NULL;

 acc = getdword (blob:data, pos:8);
 if (acc != 0)
   return NULL;

 acc = getdword (blob:data, pos:20);
 if (acc != 0)
   return NULL;

 return substr (data, 24, strlen(data)-1);
}


function rpc_getport (socket, prog, vers, proto, udp)
{
 local_var packet, data;

 data =
	mkdword (prog) +
	mkdword (vers) +
	mkdword (proto) +
	mkdword (0);

 # portmapper : prog:100000 version:2 procedure:GETPORT(3)
 packet = rpc_packet (prog:0x186a0, vers:2, proc:3, data:data, udp:udp);

 data = rpc_sendrecv (socket:socket, packet:packet, udp:udp);
 if (isnull(data) || (strlen(data) != 4))
   return NULL;

 return getdword (blob:data, pos:0);
}


function get_rpc_port2(program, protocol, portmap, vers)
{
 local_var port, broken,soc;

 if(isnull(portmap))
 {
  port = int(get_kb_item("rpc/portmap"));
  if (port == 0)
    port = 111;
 }
 else 
  port = portmap;
 	  
 broken = get_kb_item(string("/tmp/rpc/noportmap/", port));
 if (broken)
   return 0;

 soc = open_sock_udp(port);
 if (!soc)
   return 0;

 if ( isnull(vers) ) vers = 0;

 port = rpc_getport(socket:soc, prog:program, vers:vers, proto:protocol, udp:TRUE);
 close(soc);

 if(!port)
 {
  set_kb_item(name:string("/tmp/rpc/noportmap/", port), value:TRUE);
  return 0;
 }
 
 return port;
}


function register_stream(s)
{
 __rpc_stream = s;
 __rpc_stream_length = strlen(s);
 __rpc_stream_pos = 0;
 __rpc_stream_error = FALSE;
}


function xdr_getdword()
{
 local_var d;

 if ((__rpc_stream_pos + 4) > __rpc_stream_length)
 {
  __rpc_stream_error = TRUE;
  return NULL;
 }

 d = getdword(blob:__rpc_stream, pos:__rpc_stream_pos);
 __rpc_stream_pos += 4;

 return d;
}


function xdr_getstring()
{
 local_var s, d, tmps, i, len;

 d = xdr_getdword();
 if (isnull(d))
   return NULL;

 if ((__rpc_stream_pos + d) > __rpc_stream_length)
 {
  __rpc_stream_error = TRUE;
  return NULL;
 }

 tmps = substr(__rpc_stream, __rpc_stream_pos, __rpc_stream_pos+d-1);
 __rpc_stream_pos += d;

 s = NULL;
 len = strlen(tmps);
 for (i=0; i < len; i++)
 {
  if (tmps[i] == '\0')
    return s;
  else
   s += tmps[i];
 }

 return s;
}


function stream_error()
{
 return __rpc_stream_error;
}