#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27102);
 script_cve_id("CVE-2006-5456", "CVE-2007-0770");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: This update fixes a broken patch for CVE-2006-5456 in GraphicsMagick. (GraphicsMagick-2593)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch GraphicsMagick-2593.

Description :

This update fixes a broken patch for CVE-2006-5456 and
minor non-security issues. (CVE-2007-0770)


Solution : 

Install the security patch GraphicsMagick-2593.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the GraphicsMagick-2593 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"GraphicsMagick-1.1.7-35.1", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"GraphicsMagick-c++-1.1.7-35.1", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"GraphicsMagick-c++-devel-1.1.7-35.1", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"GraphicsMagick-devel-1.1.7-35.1", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"perl-GraphicsMagick-1.1.7-35.1", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
