#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27105);
 script_cve_id("CVE-2006-5456");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: ImageMagick: Securityfix for two security problems. (ImageMagick-2235)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch ImageMagick-2235.

Description :

Two security problems were found in GraphicsMagick which
are also present in ImageMagick.

CVE-2006-5456: Multiple buffer overflows in ImageMagick
allowed user-assisted attackers to cause a denial of
service and possibly execute arbitrary code via (1) a DCM
image that is not properly handled by the ReadDCMImage
function in coders/dcm.c, or (2) a PALM image that is not
properly handled by the ReadPALMImage function in
coders/palm.c.

Additionaly a segfault regression when converting a PGM
image was fixed on SLE 10.


Solution : 

Install the security patch ImageMagick-2235.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the ImageMagick-2235 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"ImageMagick-6.2.5-16.10", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"ImageMagick-Magick++-6.2.5-16.10", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"ImageMagick-Magick++-devel-6.2.5-16.10", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"ImageMagick-devel-6.2.5-16.10", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"perl-PerlMagick-6.2.5-16.10", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
