#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27510);
 script_cve_id("CVE-2006-1861", "CVE-2006-3467");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: NX security update (NX-4555)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch NX-4555.

Description :

The XFree code contained in NX was prone to integer
overflows (CVE-2006-1861) and insufficiently protected
against specially crafted PCF files (CVE-2006-3467).


Solution : 

Install the security patch NX-4555.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the NX-4555 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"NX-1.5.0-41.3", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"NX-1.5.0-75", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"NX-2.1.0-35.2", release:"SUSE10.3") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
