#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27133);
 
 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: NetworkManager security update (NetworkManager-1434)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch NetworkManager-1434.

Description :

NetworkManager automatically started ypbind and autofs if 
the DHCP server provided a NIS server address.


Solution : 

Install the security patch NetworkManager-1434.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the NetworkManager-1434 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"NetworkManager-0.6.2-32.11", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"NetworkManager-devel-0.6.2-32.11", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"NetworkManager-glib-0.6.2-32.11", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"NetworkManager-gnome-0.6.2-32.11", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
