#
# (C) Tenable Network Security
#
# This plugin text was extracted from SuSE Security Advisory SUSE-SA:2006:032
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24413);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "SUSE-SA:2006:032: sendmail";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory SUSE-SA:2006:032 (sendmail).


The Mail Transfer Agent sendmail has a remote exploitable problem,
where a specially crafted MIME messages can crash sendmail and block
queue processing.

This issue is tracked by the Mitre CVE ID CVE-2006-1173 and CERT
VU#146718.


Solution : http://www.novell.com/linux/security/advisories/2006_32_sendmail.html
Risk factor : Medium";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the sendmail package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"sendmail-8.13.4-8.6", release:"SUSE10.0") )
{
 security_warning(0);
 exit(0);
}
if ( rpm_check( reference:"sendmail-8.12.11-2.7", release:"SUSE9.1") )
{
 security_warning(0);
 exit(0);
}
if ( rpm_check( reference:"sendmail-8.13.1-5.6", release:"SUSE9.2") )
{
 security_warning(0);
 exit(0);
}
if ( rpm_check( reference:"sendmail-8.13.3-5.6", release:"SUSE9.3") )
{
 security_warning(0);
 exit(0);
}
