#
# (C) Tenable Network Security
#
# This plugin text was extracted from SuSE Security Advisory SUSE-SA:2006:033
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24414);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "SUSE-SA:2006:033: awstats";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory SUSE-SA:2006:033 (awstats).


This update fixes remote code execution vulnerabilities in the WWW
statistical analyzer awstats.

Since back porting awstats fixes is error prone we have upgraded it
to upstream version 6.6 which also includes new features.

Following security issues were fixed:
- CVE-2006-2237: missing sanitizing of the 'migrate' parameter. #173041
- CVE-2006-2644: missing sanitizing of the 'configdir' parameter. #173041
- Make sure open() only opens files for read/write by adding explicit <
and >.


Solution : http://www.novell.com/linux/security/advisories/2006_33_awstats.html
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the awstats package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"awstats-6.6-0.1", release:"SUSE10.0") )
{
 security_hole(0);
 exit(0);
}
if ( rpm_check( reference:"awstats-6.6-0.1", release:"SUSE9.1") )
{
 security_hole(0);
 exit(0);
}
if ( rpm_check( reference:"awstats-6.6-0.1", release:"SUSE9.2") )
{
 security_hole(0);
 exit(0);
}
if ( rpm_check( reference:"awstats-6.6-0.1", release:"SUSE9.3") )
{
 security_hole(0);
 exit(0);
}
