#
# (C) Tenable Network Security
#
# This plugin text was extracted from SuSE Security Advisory SUSE-SA:2006:053
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24431);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "SUSE-SA:2006:053: flash-player";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory SUSE-SA:2006:053 (flash-player).


Multiple input validation errors have been identified in the Macromedia
Flash Player that could lead to the potential execution of arbitrary
code.

These vulnerabilities could be accessed through content delivered
from a remote location via the user's web browser, email client,
or other applications that include or reference the Flash
Player. (CVE-2006-3311, CVE-2006-3587, CVE-2006-3588)

These updates also include changes to prevent circumvention of the
'allowScriptAccess' option. (CVE-2006-4640)


Solution : http://www.novell.com/linux/security/advisories/2006_53_flashplayer.html
Risk factor : Medium";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the flash-player package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"flash-player-7.0.68.0-1.1", release:"SUSE10.0") )
{
 security_warning(0);
 exit(0);
}
if ( rpm_check( reference:"flash-player-7.0.68.0-1.1", release:"SUSE9.2") )
{
 security_warning(0);
 exit(0);
}
if ( rpm_check( reference:"flash-player-7.0.68.0-1.1", release:"SUSE9.3") )
{
 security_warning(0);
 exit(0);
}
