#
# (C) Tenable Network Security
#
# This plugin text was extracted from SuSE Security Advisory SUSE-SA:2006:056
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24434);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "SUSE-SA:2006:056: gzip";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory SUSE-SA:2006:056 (gzip).


The gzip tool does not handle some specific values correctly when unpacking
archives. This leads to vulnerabilities like buffer overflows or infinite
loops.

Various different programs like mail clients, file explorer, etc. use gzip
and if a user can be deveived to unpack the archive of an attacker these
bugs can lead to remote system compromise.

Thanks to Tavis Ormandy, Google Security Team for informing us about this
issue.


Solution : http://www.novell.com/linux/security/advisories/2006_56_gzip.html
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the gzip package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"gzip-1.3.5-144.2", release:"SUSE10.0") )
{
 security_hole(0);
 exit(0);
}
if ( rpm_check( reference:"gzip-1.3.5-139.2", release:"SUSE9.2") )
{
 security_hole(0);
 exit(0);
}
if ( rpm_check( reference:"gzip-1.3.5-140.2", release:"SUSE9.3") )
{
 security_hole(0);
 exit(0);
}
