#
# (C) Tenable Network Security
#
# This plugin text was extracted from SuSE Security Advisory SUSE-SA:2006:061
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24439);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "SUSE-SA:2006:061: opera";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory SUSE-SA:2006:061 (opera).


The web browser Opera has been updated to fix 2 security problems.

CVE-2006-4339: Opera was affected by the RSA signature checking problem found in
openssl, since it is statically linked against openssl.

CVE-2006-4819: A URL tag parsing heap overflow in Opera could be used to
potentially execute code.

Solution : http://www.novell.com/linux/security/advisories/2006_61_opera.html
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the opera package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"opera-9.02-4.1", release:"SUSE10.0") )
{
 security_hole(0);
 exit(0);
}
if ( rpm_check( reference:"opera-9.02-4.1", release:"SUSE9.2") )
{
 security_hole(0);
 exit(0);
}
if ( rpm_check( reference:"opera-9.02-4.1", release:"SUSE9.3") )
{
 security_hole(0);
 exit(0);
}
