#
# (C) Tenable Network Security
#
# This plugin text was extracted from SuSE Security Advisory SUSE-SA:2006:063
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24441);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "SUSE-SA:2006:063: Qt";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory SUSE-SA:2006:063 (Qt).


Multiple integer overflows have been found in image processing
functions within the Qt class library, used for instance by the web
browser 'konqueror' and its rendering engine 'khtml'.

These problems could potentially lead to heap overflows and code
execution or just a browser crash (denial of service).

This problem has the Mitre CVE ID CVE-2006-4811.


Solution : http://www.novell.com/linux/security/advisories/2006_63_qt.html
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the Qt package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"qt-4.0.1-10.2", release:"SUSE10.0") )
{
 security_hole(0);
 exit(0);
}
if ( rpm_check( reference:"qt3-3.3.4-28.7", release:"SUSE10.0") )
{
 security_hole(0);
 exit(0);
}
if ( rpm_check( reference:"qt3-static-3.3.4-28.7", release:"SUSE10.0") )
{
 security_hole(0);
 exit(0);
}
if ( rpm_check( reference:"qt3-3.3.3-24.2", release:"SUSE9.2") )
{
 security_hole(0);
 exit(0);
}
if ( rpm_check( reference:"qt3-static-3.3.3-24.2", release:"SUSE9.2") )
{
 security_hole(0);
 exit(0);
}
if ( rpm_check( reference:"qt3-3.3.4-11.5", release:"SUSE9.3") )
{
 security_hole(0);
 exit(0);
}
if ( rpm_check( reference:"qt3-static-3.3.4-11.4", release:"SUSE9.3") )
{
 security_hole(0);
 exit(0);
}
