#
# (C) Tenable Network Security
#
# This plugin text was extracted from SuSE Security Advisory SUSE-SA:2006:068
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24445);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "SUSE-SA:2006:068: MozillaFirefox,MozillaThunderbird,seamonkey";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory SUSE-SA:2006:068 (MozillaFirefox,MozillaThunderbird,seamonkey).


MozillaFirefox has been updated to the security update release
1.5.0.8, MozillaThunderbird has been updated to 1.5.0.8, and the
Mozilla Seamonkey suite has been updated to 1.0.6 to fix the following
security issues.



Solution : http://www.novell.com/linux/security/advisories/2006_68_mozilla.html
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the MozillaFirefox,MozillaThunderbird,seamonkey package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"MozillaFirefox-1.5.0.8-0.2", release:"SUSE10.0") )
{
 security_hole(0);
 exit(0);
}
if ( rpm_check( reference:"MozillaFirefox-translations-1.5.0.8-0.2", release:"SUSE10.0") )
{
 security_hole(0);
 exit(0);
}
if ( rpm_check( reference:"MozillaThunderbird-1.5.0.8-0.2", release:"SUSE10.0") )
{
 security_hole(0);
 exit(0);
}
if ( rpm_check( reference:"MozillaFirefox-1.5.0.8-0.1", release:"SUSE9.3") )
{
 security_hole(0);
 exit(0);
}
if ( rpm_check( reference:"MozillaFirefox-translations-1.5.0.8-0.1", release:"SUSE9.3") )
{
 security_hole(0);
 exit(0);
}
if ( rpm_check( reference:"MozillaThunderbird-1.5.0.8-0.1", release:"SUSE9.3") )
{
 security_hole(0);
 exit(0);
}
