#
# (C) Tenable Network Security
#
# This plugin text was extracted from SuSE Security Advisory SUSE-SA:2006:071
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24448);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "SUSE-SA:2006:071: phpMyAdmin";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory SUSE-SA:2006:071 (phpMyAdmin).


The phpMyAdmin package was upgraded to version 2.9.1.1.

While we usually do not do version upgrades, fixing the occurring
security problems of phpMyAdmin got too difficult so we decided to
go with the current upstream version.

This release includes fixes for the previously not fixed security problems
tracked by the Mitre CVE IDs CVE-2006-3388, CVE-2006-5116, CVE-2006-5117,
and CVE-2006-5718 and of course all other bugs fixed in 2.9.1.1.


Solution : http://www.novell.com/linux/security/advisories/2006_71_phpmyadmin.html
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the phpMyAdmin package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"phpMyAdmin-2.9.1.1-2.1", release:"SUSE10.0") )
{
 security_hole(0);
 exit(0);
}
if ( rpm_check( reference:"phpMyAdmin-2.9.1.1-2.1", release:"SUSE9.3") )
{
 security_hole(0);
 exit(0);
}
