#
# (C) Tenable Network Security
#
# This plugin text was extracted from SuSE Security Advisory SUSE-SA:2006:073
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24450);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "SUSE-SA:2006:073: mono-core";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory SUSE-SA:2006:073 (mono-core).


Sebastian Krahmer of SUSE Security found that the Mono
System.Xml.Serialization class contained a /tmp race which potentially
allows local attackers to execute code as the user using the
Serialization method.

This is tracked by the Mitre CVE ID CVE-2006-5072.

Packages for all affected distributions were released on November 10th,
and for SLE 10 on November 27th.


Solution : http://www.novell.com/linux/security/advisories/2006_73_mono.html
Risk factor : Medium";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the mono-core package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"bytefx-data-mysql-1.1.8.3-6.3", release:"SUSE10.0") )
{
 security_warning(0);
 exit(0);
}
if ( rpm_check( reference:"ibm-data-db2-1.1.8.3-6.3", release:"SUSE10.0") )
{
 security_warning(0);
 exit(0);
}
if ( rpm_check( reference:"mono-basic-1.1.8.3-6.3", release:"SUSE10.0") )
{
 security_warning(0);
 exit(0);
}
if ( rpm_check( reference:"mono-core-1.1.8.3-6.3", release:"SUSE10.0") )
{
 security_warning(0);
 exit(0);
}
if ( rpm_check( reference:"mono-data-1.1.8.3-6.3", release:"SUSE10.0") )
{
 security_warning(0);
 exit(0);
}
if ( rpm_check( reference:"mono-data-oracle-1.1.8.3-6.3", release:"SUSE10.0") )
{
 security_warning(0);
 exit(0);
}
if ( rpm_check( reference:"mono-data-postgresql-1.1.8.3-6.3", release:"SUSE10.0") )
{
 security_warning(0);
 exit(0);
}
if ( rpm_check( reference:"mono-data-sqlite-1.1.8.3-6.3", release:"SUSE10.0") )
{
 security_warning(0);
 exit(0);
}
if ( rpm_check( reference:"mono-data-sybase-1.1.8.3-6.3", release:"SUSE10.0") )
{
 security_warning(0);
 exit(0);
}
if ( rpm_check( reference:"mono-devel-1.1.8.3-6.3", release:"SUSE10.0") )
{
 security_warning(0);
 exit(0);
}
if ( rpm_check( reference:"mono-extras-1.1.8.3-6.3", release:"SUSE10.0") )
{
 security_warning(0);
 exit(0);
}
if ( rpm_check( reference:"mono-ikvm-1.1.8.3-6.3", release:"SUSE10.0") )
{
 security_warning(0);
 exit(0);
}
if ( rpm_check( reference:"mono-locale-extras-1.1.8.3-6.3", release:"SUSE10.0") )
{
 security_warning(0);
 exit(0);
}
if ( rpm_check( reference:"mono-nunit-1.1.8.3-6.3", release:"SUSE10.0") )
{
 security_warning(0);
 exit(0);
}
if ( rpm_check( reference:"mono-web-1.1.8.3-6.3", release:"SUSE10.0") )
{
 security_warning(0);
 exit(0);
}
if ( rpm_check( reference:"mono-winforms-1.1.8.3-6.3", release:"SUSE10.0") )
{
 security_warning(0);
 exit(0);
}
if ( rpm_check( reference:"bytefx-data-mysql-1.1.4-15.2", release:"SUSE9.3") )
{
 security_warning(0);
 exit(0);
}
if ( rpm_check( reference:"ibm-data-db2-1.1.4-15.2", release:"SUSE9.3") )
{
 security_warning(0);
 exit(0);
}
if ( rpm_check( reference:"mono-basic-1.1.4-15.2", release:"SUSE9.3") )
{
 security_warning(0);
 exit(0);
}
if ( rpm_check( reference:"mono-core-1.1.4-15.2", release:"SUSE9.3") )
{
 security_warning(0);
 exit(0);
}
if ( rpm_check( reference:"mono-data-1.1.4-15.2", release:"SUSE9.3") )
{
 security_warning(0);
 exit(0);
}
if ( rpm_check( reference:"mono-data-oracle-1.1.4-15.2", release:"SUSE9.3") )
{
 security_warning(0);
 exit(0);
}
if ( rpm_check( reference:"mono-data-postgresql-1.1.4-15.2", release:"SUSE9.3") )
{
 security_warning(0);
 exit(0);
}
if ( rpm_check( reference:"mono-data-sqlite-1.1.4-15.2", release:"SUSE9.3") )
{
 security_warning(0);
 exit(0);
}
if ( rpm_check( reference:"mono-data-sybase-1.1.4-15.2", release:"SUSE9.3") )
{
 security_warning(0);
 exit(0);
}
if ( rpm_check( reference:"mono-devel-1.1.4-15.2", release:"SUSE9.3") )
{
 security_warning(0);
 exit(0);
}
if ( rpm_check( reference:"mono-extras-1.1.4-15.2", release:"SUSE9.3") )
{
 security_warning(0);
 exit(0);
}
if ( rpm_check( reference:"mono-ikvm-1.1.4-15.2", release:"SUSE9.3") )
{
 security_warning(0);
 exit(0);
}
if ( rpm_check( reference:"mono-locale-extras-1.1.4-15.2", release:"SUSE9.3") )
{
 security_warning(0);
 exit(0);
}
if ( rpm_check( reference:"mono-web-1.1.4-15.2", release:"SUSE9.3") )
{
 security_warning(0);
 exit(0);
}
if ( rpm_check( reference:"mono-winforms-1.1.4-15.2", release:"SUSE9.3") )
{
 security_warning(0);
 exit(0);
}
