#
# (C) Tenable Network Security
#
# This plugin text was extracted from SuSE Security Advisory SUSE-SA:2007:004
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24458);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "SUSE-SA:2007:004: krb5";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory SUSE-SA:2007:004 (krb5).


Various bugs in the Kerberos5 libraries and tools were fixed which
could be used by remote attackers to crash and potentially execute
code in kadmind.

- CVE-2006-6144 / MITKRB5-SA-2006-002: the RPC library could call an
uninitialized function pointer, which created a security
vulnerability for kadmind.

- CVE-2006-6143 / MITKRB5-SA-2006-003: the GSS-API mechglue layer
could fail to initialize some output pointers, causing callers to
attempt to free uninitialized pointers.  This caused a security
vulnerability in kadmind.


Solution : http://www.novell.com/linux/security/advisories/2007_04_krb5.html
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the krb5 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"krb5-1.4.1-5.3", release:"SUSE10.0") )
{
 security_hole(0);
 exit(0);
}
if ( rpm_check( reference:"krb5-server-1.4.1-5.3", release:"SUSE10.0") )
{
 security_hole(0);
 exit(0);
}
if ( rpm_check( reference:"krb5-1.4-16.7", release:"SUSE9.3") )
{
 security_hole(0);
 exit(0);
}
if ( rpm_check( reference:"krb5-server-1.4-16.7", release:"SUSE9.3") )
{
 security_hole(0);
 exit(0);
}
