#
# (C) Tenable Network Security
#
# This plugin text was extracted from SuSE Security Advisory SUSE-SA:2007:012
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24465);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "SUSE-SA:2007:012: squid";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory SUSE-SA:2007:012 (squid).


This update fixes a remotely exploitable denial-of-service
bug in squid that can be triggered by using special ftp://
URLs. (CVE-2007-0247)
Additionally the 10.2 package needed a fix for another DoS
bug (CVE-2007-0248) and for max_user_ip handling in
ntlm_auth.



Solution : http://www.novell.com/linux/security/advisories/2007_12_squid.html
Risk factor : Medium";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the squid package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"squid-2.5.STABLE10-5.5", release:"SUSE10.0") )
{
 security_warning(0);
 exit(0);
}
if ( rpm_check( reference:"squid-2.5.STABLE9-4.9", release:"SUSE9.3") )
{
 security_warning(0);
 exit(0);
}
