#
# (C) Tenable Network Security
#
# This plugin text was extracted from SuSE Security Advisory SUSE-SA:2007:014
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24411);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "SUSE-SA:2007:014: bind";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory SUSE-SA:2007:014 (bind).


Two security problems were fixed in the ISC BIND nameserver
version 9.3.4, which are addressed by this advisory:

CVE-2007-0493: If recursion is enabled, a remote attacker can dereference
a freed fetch context causing the daemon to abort / crash.

CVE-2007-0494: By sending specific DNS query responses with multiple
RRSETS attackers could cause BIND to exit abnormally.

Updates for SUSE Linux Enterprise Server were released on Friday 26th of January,
updates for SUSE Linux and openSUSE were released on Monday 29th of January.

Solution : http://www.novell.com/linux/security/advisories/2007_14_bind.html
Risk factor : Medium";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the bind package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"bind-9.3.2-56.1", release:"SUSE10.0") )
{
 security_warning(0);
 exit(0);
}
if ( rpm_check( reference:"bind-libs-9.3.2-56.1", release:"SUSE10.0") )
{
 security_warning(0);
 exit(0);
}
if ( rpm_check( reference:"bind-utils-9.3.2-56.1", release:"SUSE10.0") )
{
 security_warning(0);
 exit(0);
}
if ( rpm_check( reference:"bind-9.3.2-56.1", release:"SUSE9.3") )
{
 security_warning(0);
 exit(0);
}
if ( rpm_check( reference:"bind-libs-9.3.2-56.1", release:"SUSE9.3") )
{
 security_warning(0);
 exit(0);
}
if ( rpm_check( reference:"bind-utils-9.3.2-56.1", release:"SUSE9.3") )
{
 security_warning(0);
 exit(0);
}
