#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29370);
 script_cve_id("CVE-2006-5857", "CVE-2007-0044", "CVE-2007-0045", "CVE-2007-0046", "CVE-2007-0047");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for acroread (acroread-2508)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch acroread-2508.

Description :

The Adobe Acrobat Reader has been updated to version 7.0.9.

This update also includes following security fixes:

CVE-2006-5857: A memory corruption problem was fixed in
Adobe Acrobat
 Reader can potentially lead to code
execution.

CVE-2007-0044: Universal Cross Site Request Forgery (CSRF)
problems
 were fixed in the Acrobat Reader plugin which
could be
 exploited by remote attackers to conduct CSRF
attacks
 using any site that is providing PDFs.

CVE-2007-0045: Cross site scripting problems in the Acrobat
Reader
 plugin were fixed, which could be exploited by
remote
 attackers to conduct XSS attacks against any site
that
 is providing PDFs.

CVE-2007-0046: A double free problem in the Acrobat Reader
plugin was fixed
 which could be used by remote attackers
to potentially execute
 arbitrary code.
 Note that all
platforms using Adobe Reader currently have
 counter
measures against such attack where it will just
 cause a
controlled abort().

CVE-2007-0047 and CVE-2007-0048 affect only Microsoft
Windows and
 Internet Explorer.


Solution : 

Install the security patch acroread-2508.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the acroread-2508 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"acroread-7.0.9-1.2", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
