#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27156);
 script_cve_id("CVE-2006-5444", "CVE-2006-5445");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: asterisk: Security update to fix problems in CISCO SCCP and SIP channel driver. (asterisk-2272)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch asterisk-2272.

Description :

This update fixes 2 security problem in the PBX software
Asterisk.

CVE-2006-5444: Integer overflow in the get_input function
in the Skinny channel driver (chan_skinny.c) as used by
Cisco SCCP phones, allows remote attackers to execute
arbitrary code via a certain dlen value that passes a
signed integer comparison and leads to a heap-based buffer
overflow.

CVE-2006-5445: A vulnerability in the SIP channel driver
(channels/chan_sip.c) in Asterisk on SUSE Linux 10.1 allows
remote attackers to cause a denial of service (resource
consumption) via unspecified vectors that result in the
creation of 'a real pvt structure' that uses more resources
than necessary.


Solution : 

Install the security patch asterisk-2272.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the asterisk-2272 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"asterisk-1.2.5-12.8", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
