#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(31390);
 script_cve_id("CVE-2007-6430", "CVE-2007-6170");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: asterisk security update (asterisk-5062)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch asterisk-5062.

Description :

Attackers could bypass host based authentication by using a
valid username (CVE-2007-6430)

Attackers could inject SQL commands under certain
circumstances if 'cdr_pgsql' was used (CVE-2007-6170)


Solution : 

Install the security patch asterisk-5062.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the asterisk-5062 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"asterisk-1.2.5-12.18", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"asterisk-alsa-1.2.5-12.18", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"asterisk-odbc-1.2.5-12.18", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"asterisk-pgsql-1.2.5-12.18", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"asterisk-spandsp-1.2.5-12.18", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"asterisk-zaptel-1.2.5-12.18", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"asterisk-1.2.13-27", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"asterisk-alsa-1.2.13-27", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"asterisk-odbc-1.2.13-27", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"asterisk-pgsql-1.2.13-27", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"asterisk-spandsp-1.2.13-27", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"asterisk-zaptel-1.2.13-27", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
