#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29383);
 script_cve_id("CVE-2007-3372");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for avahi (avahi-3845)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch avahi-3845.

Description :

Local attackers could send empty TXT data via D-BUS,
causing the avahi daemon to exit. CVE-2007-3372 has been
assigned to this issue.


Solution : 

Install the security patch avahi-3845.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the avahi-3845 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"avahi-0.6.5-29.16", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"avahi-glib-0.6.5-29.16", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
