#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27163);
 script_cve_id("CVE-2006-2237", "CVE-2006-2644");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: awstats: security update for remote command injection (awstats-1612)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch awstats-1612.

Description :

This update fixes remote code execution vulnerabilities in 
awstats.  Since backporting awstats fixes is error prone we 
have upgraded it to upstream version 6.6, which also 
includes new features.  Security issues fixed:  - 
CVE-2006-2237: missing sanitizing of the 'migrate' 
parameter. #173041 - CVE-2006-2644: missing sanitizing of 
the 'configdir' parameter. #173041 - Make sure open() only 
opens files for read/write by adding explicit < and >.


Solution : 

Install the security patch awstats-1612.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the awstats-1612 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"awstats-6.6-0.1", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
