#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29386);
 script_cve_id("CVE-2006-4339");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for bind (bind-2268)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch bind-2268.

Description :

The RSA signature problem tracked by the Mitre CVE ID
CVE-2006-4339 also affects the DNSSEC implementation in the
BIND nameserver. This update fixes this problem.


Solution : 

Install the security patch bind-2268.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the bind-2268 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"bind-9.3.2-17.11", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"bind-libs-9.3.2-17.11", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"bind-utils-9.3.2-17.11", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"bind-libs-9.3.2-17.11", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"bind-utils-9.3.2-17.11", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
