#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27169);
 script_cve_id("CVE-2006-6799");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: cacti: Securityupdate to fix command injection (cacti-2447)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch cacti-2447.

Description :

A command injection in cmd.php in cacti was fixed, which
might
 have allowed remote attackers to inject commands and
so execute code.
 (CVE-2006-6799)


Solution : 

Install the security patch cacti-2447.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the cacti-2447 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"cacti-0.8.6h-15.2", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"cacti-0.8.6h-36.2", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
