#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27170);
 script_cve_id("CVE-2006-3126");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: capi4hylafax security update (capi4hylafax-2366)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch capi4hylafax-2366.

Description :

By using shell meta characters in the sender number remote
attackers
 could execute arbitrary commands (CVE-2006-3126).


Solution : 

Install the security patch capi4hylafax-2366.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the capi4hylafax-2366 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"capi4hylafax-4.2.5-14.5", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"capi4hylafax-4.3.0-25.2", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
