#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27178);
 script_cve_id("CVE-2007-0897", "CVE-2007-0898");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: clamav: security update to version 0.90 (clamav-2632)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch clamav-2632.

Description :

This update to ClamAV version 0.90 fixes various bugs:

CVE-2007-0897: A filedescriptor leak in the handling of CAB
files can lead to a denial of service attack against the
clamd scanner daemon caused by remote attackers.

CVE-2007-0898: A directory traversal in handling of MIME
E-Mail headers could be used by remote attackers to
overwrite local files owned by the user under which clamd
is running.


Solution : 

Install the security patch clamav-2632.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the clamav-2632 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"clamav-0.90-0.2", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"clamav-0.90-0.1", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
