#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27186);
 script_cve_id("CVE-2007-2958");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: claws-mail: This update fixes a format string bug. (claws-mail-4495)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch claws-mail-4495.

Description :

This update fixes a format string bug in the
inc_put_error() function. This bug is triggered when error
messages from the POP3 server are displayed and can be
exploited remotely to execute arbitrary code.
(CVE-2007-2958)


Solution : 

Install the security patch claws-mail-4495.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the claws-mail-4495 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"claws-mail-2.10.0-35.2", release:"SUSE10.3") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"claws-mail-devel-2.10.0-35.2", release:"SUSE10.3") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
