#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(31391);
 script_cve_id("CVE-2007-5135");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: compat-openssl097g: Fixed buffer overflow in SSL_get_shared_ciphers (compat-openssl097g-5054)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch compat-openssl097g-5054.

Description :

This update of openssl fixes a off-by-one buffer overflow
in function SSL_get_shared_ciphers(). This vulnerability
potentially allows remote code execution; depending on
memory layout of the process. (CVE-2007-5135)

We released updates for openssl already, but an update for
the compat 0.9.7g openssl libraries was missing and is
provided with this patch.


Solution : 

Install the security patch compat-openssl097g-5054.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the compat-openssl097g-5054 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"compat-openssl097g-0.9.7g-13.9", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"compat-openssl097g-32bit-0.9.7g-13.9", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"compat-openssl097g-64bit-0.9.7g-13.9", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"compat-openssl097g-0.9.7g-35", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"compat-openssl097g-32bit-0.9.7g-35", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"compat-openssl097g-64bit-0.9.7g-35", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"compat-openssl097g-0.9.7g-75.2", release:"SUSE10.3") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"compat-openssl097g-32bit-0.9.7g-75.2", release:"SUSE10.3") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"compat-openssl097g-64bit-0.9.7g-75.2", release:"SUSE10.3") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
